@extends('components.layouts.admin')

@section('title', 'Edit Deposit')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit Deposit</h1>
                <p class="text-gray-600">Update deposit information and status</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="eye" href="{{ route('admin.deposits.show', $deposit) }}" variant="outline">
                    View Deposit
                </flux:button>
                <flux:button icon="arrow-left" href="{{ route('admin.deposits.index') }}" variant="outline">
                    Back to Deposits
                </flux:button>
            </div>
        </div>

        <!-- Edit Form -->
        <form method="POST" action="{{ route('admin.deposits.update', $deposit) }}" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Basic Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Transaction ID (Read-only) -->
                    <flux:field>
                        <flux:label>Transaction ID</flux:label>
                        <flux:input 
                            value="{{ $deposit->transaction_id }}" 
                            readonly 
                            class="bg-gray-50"
                        />
                    </flux:field>

                    <!-- Reference Number (Read-only) -->
                    <flux:field>
                        <flux:label>Reference Number</flux:label>
                        <flux:input 
                            value="{{ $deposit->reference_number }}" 
                            readonly 
                            class="bg-gray-50"
                        />
                    </flux:field>

                    <!-- External Reference -->
                    <flux:field>
                        <flux:label>External Reference</flux:label>
                        <flux:input 
                            name="external_reference" 
                            value="{{ old('external_reference', $deposit->external_reference) }}"
                            placeholder="External reference number"
                        />
                        <flux:error name="external_reference" />
                    </flux:field>

                    <!-- User -->
                    <flux:field>
                        <flux:label>User</flux:label>
                        <flux:select name="user_id">
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('user_id', $deposit->user_id) == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }} ({{ $user->email }})
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="user_id" />
                    </flux:field>

                    <!-- Deposit Type -->
                    <flux:field>
                        <flux:label>Deposit Type</flux:label>
                        <flux:select name="subcategory">
                            <option value="cheque_deposit" {{ old('subcategory', $deposit->subcategory) === 'cheque_deposit' ? 'selected' : '' }}>Cheque Deposit</option>
                            <option value="wire_deposit" {{ old('subcategory', $deposit->subcategory) === 'wire_deposit' ? 'selected' : '' }}>Wire Deposit</option>
                            <option value="ach_deposit" {{ old('subcategory', $deposit->subcategory) === 'ach_deposit' ? 'selected' : '' }}>ACH Deposit</option>
                            <option value="card_deposit" {{ old('subcategory', $deposit->subcategory) === 'card_deposit' ? 'selected' : '' }}>Card Deposit</option>
                            <option value="cash_deposit" {{ old('subcategory', $deposit->subcategory) === 'cash_deposit' ? 'selected' : '' }}>Cash Deposit</option>
                            <option value="digital_wallet_deposit" {{ old('subcategory', $deposit->subcategory) === 'digital_wallet_deposit' ? 'selected' : '' }}>Digital Wallet Deposit</option>
                            <option value="interest_deposit" {{ old('subcategory', $deposit->subcategory) === 'interest_deposit' ? 'selected' : '' }}>Interest Deposit</option>
                            <option value="refund_deposit" {{ old('subcategory', $deposit->subcategory) === 'refund_deposit' ? 'selected' : '' }}>Refund Deposit</option>
                        </flux:select>
                        <flux:error name="subcategory" />
                    </flux:field>

                    <!-- Payment Method -->
                    <flux:field>
                        <flux:label>Payment Method</flux:label>
                        <flux:select name="payment_method">
                            <option value="cheque" {{ old('payment_method', $deposit->payment_method) === 'cheque' ? 'selected' : '' }}>Cheque</option>
                            <option value="card" {{ old('payment_method', $deposit->payment_method) === 'card' ? 'selected' : '' }}>Card</option>
                            <option value="bank_transfer" {{ old('payment_method', $deposit->payment_method) === 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                            <option value="digital_wallet" {{ old('payment_method', $deposit->payment_method) === 'digital_wallet' ? 'selected' : '' }}>Digital Wallet</option>
                            <option value="cash" {{ old('payment_method', $deposit->payment_method) === 'cash' ? 'selected' : '' }}>Cash</option>
                            <option value="wire" {{ old('payment_method', $deposit->payment_method) === 'wire' ? 'selected' : '' }}>Wire</option>
                            <option value="ach" {{ old('payment_method', $deposit->payment_method) === 'ach' ? 'selected' : '' }}>ACH</option>
                        </flux:select>
                        <flux:error name="payment_method" />
                    </flux:field>

                    <!-- Status -->
                    <flux:field>
                        <flux:label>Status</flux:label>
                        <flux:select name="status">
                            <option value="pending" {{ old('status', $deposit->status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="processing" {{ old('status', $deposit->status) === 'processing' ? 'selected' : '' }}>Processing</option>
                            <option value="completed" {{ old('status', $deposit->status) === 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="failed" {{ old('status', $deposit->status) === 'failed' ? 'selected' : '' }}>Failed</option>
                            <option value="cancelled" {{ old('status', $deposit->status) === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            <option value="reversed" {{ old('status', $deposit->status) === 'reversed' ? 'selected' : '' }}>Reversed</option>
                        </flux:select>
                        <flux:error name="status" />
                    </flux:field>

                    <!-- Verification Status -->
                    <flux:field>
                        <flux:label>Verification Status</flux:label>
                        <flux:select name="verification_status">
                            <option value="pending" {{ old('verification_status', $deposit->verification_status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="verified" {{ old('verification_status', $deposit->verification_status) === 'verified' ? 'selected' : '' }}>Verified</option>
                            <option value="rejected" {{ old('verification_status', $deposit->verification_status) === 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </flux:select>
                        <flux:error name="verification_status" />
                    </flux:field>
                </div>
            </div>

            <!-- Financial Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Financial Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Amount -->
                    <flux:field>
                        <flux:label>Amount</flux:label>
                        <flux:input 
                            name="amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('amount', $deposit->amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="amount" />
                    </flux:field>

                    <!-- Currency -->
                    <flux:field>
                        <flux:label>Currency</flux:label>
                        <flux:select name="currency">
                            <option value="USD" {{ old('currency', $deposit->currency) === 'USD' ? 'selected' : '' }}>USD</option>
                            <option value="EUR" {{ old('currency', $deposit->currency) === 'EUR' ? 'selected' : '' }}>EUR</option>
                            <option value="GBP" {{ old('currency', $deposit->currency) === 'GBP' ? 'selected' : '' }}>GBP</option>
                            <option value="NGN" {{ old('currency', $deposit->currency) === 'NGN' ? 'selected' : '' }}>NGN</option>
                        </flux:select>
                        <flux:error name="currency" />
                    </flux:field>

                    <!-- Exchange Rate -->
                    <flux:field>
                        <flux:label>Exchange Rate</flux:label>
                        <flux:input 
                            name="exchange_rate" 
                            type="number"
                            step="0.0001"
                            value="{{ old('exchange_rate', $deposit->exchange_rate) }}"
                            placeholder="1.0000"
                        />
                        <flux:error name="exchange_rate" />
                    </flux:field>

                    <!-- Converted Amount -->
                    <flux:field>
                        <flux:label>Converted Amount</flux:label>
                        <flux:input 
                            name="converted_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('converted_amount', $deposit->converted_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="converted_amount" />
                    </flux:field>

                    <!-- Fee Amount -->
                    <flux:field>
                        <flux:label>Fee Amount</flux:label>
                        <flux:input 
                            name="fee_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('fee_amount', $deposit->fee_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="fee_amount" />
                    </flux:field>

                    <!-- Tax Amount -->
                    <flux:field>
                        <flux:label>Tax Amount</flux:label>
                        <flux:input 
                            name="tax_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('tax_amount', $deposit->tax_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="tax_amount" />
                    </flux:field>

                    <!-- Net Amount -->
                    <flux:field>
                        <flux:label>Net Amount</flux:label>
                        <flux:input 
                            name="net_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('net_amount', $deposit->net_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="net_amount" />
                    </flux:field>
                </div>
            </div>

            <!-- Account Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- To Account -->
                    <flux:field>
                        <flux:label>To Account</flux:label>
                        <flux:select name="to_account_id">
                            <option value="">Select Account</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}" {{ old('to_account_id', $deposit->to_account_id) == $account->id ? 'selected' : '' }}>
                                    {{ $account->account_number }} - {{ $account->account_name }}
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="to_account_id" />
                    </flux:field>
                </div>
            </div>

            <!-- Deposit-Specific Details -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Deposit Details</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Cheque Details -->
                    <div class="md:col-span-2">
                        <h4 class="text-sm font-medium text-gray-700 mb-4">Cheque Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field>
                                <flux:label>Cheque Number</flux:label>
                                <flux:input 
                                    name="cheque_number" 
                                    value="{{ old('cheque_number', $deposit->metadata['cheque_details']['cheque_number'] ?? '') }}"
                                    placeholder="Cheque number"
                                />
                                <flux:error name="cheque_number" />
                            </flux:field>

                            <flux:field>
                                <flux:label>Bank Name</flux:label>
                                <flux:input 
                                    name="bank_name" 
                                    value="{{ old('bank_name', $deposit->metadata['cheque_details']['bank_name'] ?? '') }}"
                                    placeholder="Bank name"
                                />
                                <flux:error name="bank_name" />
                            </flux:field>

                            <flux:field>
                                <flux:label>Routing Number</flux:label>
                                <flux:input 
                                    name="routing_number" 
                                    value="{{ old('routing_number', $deposit->metadata['cheque_details']['routing_number'] ?? '') }}"
                                    placeholder="Routing number"
                                />
                                <flux:error name="routing_number" />
                            </flux:field>

                            <flux:field>
                                <flux:label>Account Number</flux:label>
                                <flux:input 
                                    name="account_number" 
                                    value="{{ old('account_number', $deposit->metadata['cheque_details']['account_number'] ?? '') }}"
                                    placeholder="Account number"
                                />
                                <flux:error name="account_number" />
                            </flux:field>
                        </div>
                    </div>

                    <!-- Card Details -->
                    <div class="md:col-span-2">
                        <h4 class="text-sm font-medium text-gray-700 mb-4">Card Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field>
                                <flux:label>Card Last Four</flux:label>
                                <flux:input 
                                    name="card_last_four" 
                                    value="{{ old('card_last_four', $deposit->metadata['card_details']['card_last_four'] ?? '') }}"
                                    placeholder="1234"
                                    maxlength="4"
                                />
                                <flux:error name="card_last_four" />
                            </flux:field>

                            <flux:field>
                                <flux:label>Card Type</flux:label>
                                <flux:input 
                                    name="card_type" 
                                    value="{{ old('card_type', $deposit->metadata['card_details']['card_type'] ?? '') }}"
                                    placeholder="Visa, Mastercard, etc."
                                />
                                <flux:error name="card_type" />
                            </flux:field>
                        </div>
                    </div>

                    <!-- Wire Details -->
                    <div class="md:col-span-2">
                        <h4 class="text-sm font-medium text-gray-700 mb-4">Wire Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field>
                                <flux:label>Wire Reference</flux:label>
                                <flux:input 
                                    name="wire_reference" 
                                    value="{{ old('wire_reference', $deposit->metadata['wire_details']['wire_reference'] ?? '') }}"
                                    placeholder="Wire reference"
                                />
                                <flux:error name="wire_reference" />
                            </flux:field>

                            <flux:field>
                                <flux:label>Wire Instructions</flux:label>
                                <flux:textarea 
                                    name="wire_instructions" 
                                    rows="3"
                                    placeholder="Wire instructions"
                                >{{ old('wire_instructions', $deposit->metadata['wire_details']['wire_instructions'] ?? '') }}</flux:textarea>
                                <flux:error name="wire_instructions" />
                            </flux:field>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Description and Notes -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Description & Notes</h3>
                <div class="space-y-6">
                    <!-- Description -->
                    <flux:field>
                        <flux:label>Description</flux:label>
                        <flux:textarea 
                            name="description" 
                            rows="3"
                            placeholder="Deposit description"
                        >{{ old('description', $deposit->description) }}</flux:textarea>
                        <flux:error name="description" />
                    </flux:field>

                    <!-- Notes -->
                    <flux:field>
                        <flux:label>Notes</flux:label>
                        <flux:textarea 
                            name="notes" 
                            rows="3"
                            placeholder="Additional notes"
                        >{{ old('notes', $deposit->notes) }}</flux:textarea>
                        <flux:error name="notes" />
                    </flux:field>
                </div>
            </div>

            <!-- Technical Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Technical Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Created At -->
                    <flux:field>
                        <flux:label>Created At</flux:label>
                        <flux:input 
                            name="created_at" 
                            type="datetime-local"
                            value="{{ old('created_at', $deposit->created_at?->format('Y-m-d\TH:i')) }}"
                        />
                        <flux:error name="created_at" />
                    </flux:field>

                    <!-- IP Address -->
                    <flux:field>
                        <flux:label>IP Address</flux:label>
                        <flux:input 
                            name="ip_address" 
                            value="{{ old('ip_address', $deposit->ip_address) }}"
                            placeholder="192.168.1.1"
                        />
                        <flux:error name="ip_address" />
                    </flux:field>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex justify-end space-x-3">
                <flux:button href="{{ route('admin.deposits.show', $deposit) }}" variant="outline">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" variant="primary">
                    Update Deposit
                </flux:button>
            </div>
        </form>
    </div>
@endsection
