@extends('components.layouts.admin')

@section('title', 'Compliance Statistics')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Compliance Statistics</h1>
            <p class="text-gray-600">Overview of compliance logs and risk assessments</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.compliance.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Compliance
            </flux:button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Logs -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="document-text" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Logs</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['total_logs']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- Pending -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="clock" class="w-8 h-8 text-yellow-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Pending</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['pending']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- Under Review -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="eye" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Under Review</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['under_review']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- High Priority -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="exclamation-triangle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">High Priority</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['high_priority']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- Critical Pending -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="exclamation-circle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Critical Pending</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['critical_pending']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- High Pending -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="exclamation-triangle" class="w-8 h-8 text-orange-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">High Pending</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['high_pending']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- Resolved Today -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Resolved Today</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['resolved_today']) }}</p>
                </div>
            </div>
        </flux:card>

        <!-- This Month -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="calendar" class="w-8 h-8 text-purple-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">This Month</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['total_this_month']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Type Breakdown -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Logs by Type</flux:heading>
            @if($typeStats->count() > 0)
                <div class="space-y-3">
                    @foreach($typeStats as $type => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $type)) }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($count / $stats['total_logs']) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No data available</p>
            @endif
        </flux:card>

        <!-- Severity Breakdown -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Logs by Severity</flux:heading>
            @if($severityStats->count() > 0)
                <div class="space-y-3">
                    @foreach($severityStats as $severity => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst($severity) }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="h-2 rounded-full {{ 
                                        $severity === 'critical' ? 'bg-red-600' : 
                                        ($severity === 'high' ? 'bg-orange-600' : 
                                        ($severity === 'medium' ? 'bg-yellow-600' : 'bg-green-600')) 
                                    }}" style="width: {{ ($count / $stats['total_logs']) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No data available</p>
            @endif
        </flux:card>
    </div>

    <!-- Status Breakdown -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Logs by Status</flux:heading>
        @if($statusStats->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                @foreach($statusStats as $status => $count)
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-gray-900">{{ $count }}</div>
                        <div class="text-sm text-gray-500">{{ ucfirst(str_replace('_', ' ', $status)) }}</div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No data available</p>
        @endif
    </flux:card>

    <!-- Recent Activity -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Recent Activity</flux:heading>
        @if($recentLogs->count() > 0)
            <div class="space-y-4">
                @foreach($recentLogs as $log)
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex items-center space-x-4">
                            <div class="flex-shrink-0">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $log->severity_color }}">
                                    {{ ucfirst($log->severity) }}
                                </span>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-900">
                                    {{ $log->type_label }} - {{ $log->category_label }}
                                </div>
                                <div class="text-sm text-gray-500">
                                    @if($log->user)
                                        {{ $log->user->name }} • 
                                    @endif
                                    {{ $log->created_at->diffForHumans() }}
                                </div>
                            </div>
                        </div>
                        <div class="flex items-center space-x-2">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $log->status_color }}">
                                {{ ucfirst(str_replace('_', ' ', $log->status)) }}
                            </span>
                            <flux:button 
                                href="{{ route('admin.compliance.show', $log) }}" 
                                variant="outline" 
                                size="sm"
                                class="text-xs"
                            >
                                View
                            </flux:button>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No recent activity</p>
        @endif
    </flux:card>
</div>
@endsection
