@extends('components.layouts.admin')

@section('title', 'Compliance Log Details')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Compliance Log Details</h1>
            <p class="text-gray-600">Review and manage compliance log #{{ $compliance->id }}</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.compliance.edit', $compliance) }}" variant="outline" class="text-xs">
                <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                Edit
            </flux:button>
            <flux:button href="{{ route('admin.compliance.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to List
            </flux:button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
                <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Type</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $compliance->type_label }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Category</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $compliance->category_label }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Severity</dt>
                        <dd class="mt-1">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $compliance->severity_color }}">
                                {{ ucfirst($compliance->severity) }}
                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Status</dt>
                        <dd class="mt-1">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $compliance->status_color }}">
                                {{ ucfirst(str_replace('_', ' ', $compliance->status)) }}
                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Created</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $compliance->created_at->format('M j, Y g:i A') }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Last Updated</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $compliance->updated_at->format('M j, Y g:i A') }}</dd>
                    </div>
                </dl>
            </flux:card>

            <!-- Description -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Description</flux:heading>
                <p class="text-sm text-gray-900">{{ $compliance->description }}</p>
            </flux:card>

            <!-- Details -->
            @if($compliance->details)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Additional Details</flux:heading>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <pre class="text-sm text-gray-900 whitespace-pre-wrap">{{ json_encode($compliance->details, JSON_PRETTY_PRINT) }}</pre>
                    </div>
                </flux:card>
            @endif

            <!-- Risk Factors -->
            @if($compliance->risk_factors && count($compliance->risk_factors) > 0)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Risk Factors</flux:heading>
                    <div class="flex flex-wrap gap-2">
                        @foreach($compliance->risk_factors as $factor)
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                                {{ ucfirst(str_replace('_', ' ', $factor)) }}
                            </span>
                        @endforeach
                    </div>
                </flux:card>
            @endif

            <!-- Admin Notes -->
            @if($compliance->admin_notes)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Admin Notes</flux:heading>
                    <p class="text-sm text-gray-900">{{ $compliance->admin_notes }}</p>
                </flux:card>
            @endif

            <!-- Resolution Notes -->
            @if($compliance->resolution_notes)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Resolution Notes</flux:heading>
                    <p class="text-sm text-gray-900">{{ $compliance->resolution_notes }}</p>
                </flux:card>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- User Information -->
            @if($compliance->user)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">User Information</flux:heading>
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Name</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $compliance->user->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Email</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $compliance->user->email }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Customer ID</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $compliance->user->customer_id ?? 'N/A' }}</dd>
                        </div>
                        <div class="pt-3">
                            <flux:button 
                                href="{{ route('admin.users.show', $compliance->user) }}" 
                                variant="outline" 
                                size="sm"
                                class="w-full"
                            >
                                View User Profile
                            </flux:button>
                        </div>
                    </div>
                </flux:card>
            @endif

            <!-- Related Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Related Information</flux:heading>
                <div class="space-y-3">
                    @if($compliance->account)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Account</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $compliance->account->account_number }} 
                                ({{ $compliance->account->account_type }})
                            </dd>
                        </div>
                    @endif

                    @if($compliance->transaction)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Transaction</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $compliance->transaction->reference_number }}
                                ({{ ucfirst($compliance->transaction->type) }})
                            </dd>
                        </div>
                    @endif

                    @if($compliance->kycDocument)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">KYC Document</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $compliance->kycDocument->document_type }}
                                ({{ ucfirst($compliance->kycDocument->status) }})
                            </dd>
                        </div>
                    @endif

                    @if($compliance->amount)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Amount</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ number_format($compliance->amount, 2) }} {{ $compliance->currency }}
                            </dd>
                        </div>
                    @endif
                </div>
            </flux:card>

            <!-- Review Information -->
            @if($compliance->reviewed_by)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Review Information</flux:heading>
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Reviewed By</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $compliance->reviewer->name ?? 'Unknown' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Reviewed At</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $compliance->reviewed_at->format('M j, Y g:i A') }}</dd>
                        </div>
                        @if($compliance->resolution_status)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Resolution Status</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst(str_replace('_', ' ', $compliance->resolution_status)) }}</dd>
                            </div>
                        @endif
                    </div>
                </flux:card>
            @endif

            <!-- Actions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Actions</flux:heading>
                <div class="space-y-3">
                    @if($compliance->status === 'pending' || $compliance->status === 'under_review')
                        <form method="POST" action="{{ route('admin.compliance.approve', $compliance) }}" onsubmit="return confirm('Approve this compliance log?');">
                            @csrf
                            <flux:button icon="check" type="submit" variant="primary" class="w-full" class="text-xs">
                                Approve
                            </flux:button>
                        </form>
                        
                        <form method="POST" action="{{ route('admin.compliance.reject', $compliance) }}" onsubmit="return confirm('Reject this compliance log?');">
                            @csrf
                            <flux:button icon="x-mark" type="submit" variant="danger" class="w-full" class="text-xs">
                                Reject
                            </flux:button>
                        </form>
                        
                        <form method="POST" action="{{ route('admin.compliance.escalate', $compliance) }}" onsubmit="return confirm('Escalate this compliance log?');">
                            @csrf
                            <flux:button icon="exclamation-triangle" type="submit" variant="primary" color="yellow" class="w-full" class="text-xs">
                                Escalate
                            </flux:button>
                        </form>
                    @endif

                    <flux:button 
                        href="{{ route('admin.compliance.edit', $compliance) }}" 
                        variant="outline" 
                        class="w-full"
                        class="text-xs"
                        icon="pencil"
                    >
                        Edit Details
                    </flux:button>

                    <form method="POST" action="{{ route('admin.compliance.destroy', $compliance) }}" onsubmit="return confirm('Delete this compliance log? This action cannot be undone.');" class="w-full">
                        @csrf
                        @method('DELETE')
                        <flux:button icon="trash" type="submit" variant="danger" class="w-full" class="text-xs">
                            Delete
                        </flux:button>
                    </form>
                </div>
            </flux:card>
        </div>
    </div>
</div>
@endsection
