@extends('components.layouts.admin')

@section('title', 'Edit Account - ' . $account->account_name)

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit Account</h1>
                <p class="text-gray-600">Update account information and settings</p>
            </div>
            <div class="flex space-x-3">
                <flux:button href="{{ route('admin.accounts.show', $account) }}" variant="outline">
                    <flux:icon name="eye" class="w-4 h-4 mr-2" />
                    View Account
                </flux:button>
                <flux:button href="{{ route('admin.accounts.index') }}" variant="outline">
                    <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                    Back to Accounts
                </flux:button>
            </div>
        </div>

        <!-- Edit Form -->
        <form method="POST" action="{{ route('admin.accounts.update', $account) }}" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Basic Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- User -->
                    <flux:field>
                        <flux:label>Account Holder</flux:label>
                        <flux:select name="user_id">
                                                    @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ old('user_id', $account->user_id) == $user->id ? 'selected' : '' }}>
                                {{ $user->name }} ({{ $user->email }})
                            </option>
                        @endforeach
                        </flux:select>
                        <flux:error name="user_id" />
                    </flux:field>

                    <!-- Account Type -->
                    <flux:field>
                        <flux:label>Account Type</flux:label>
                        <flux:select name="account_type">
                            <option value="savings" {{ old('account_type', $account->account_type) === 'savings' ? 'selected' : '' }}>Savings</option>
                            <option value="checking" {{ old('account_type', $account->account_type) === 'checking' ? 'selected' : '' }}>Checking</option>
                            <option value="business" {{ old('account_type', $account->account_type) === 'business' ? 'selected' : '' }}>Business</option>
                            <option value="investment" {{ old('account_type', $account->account_type) === 'investment' ? 'selected' : '' }}>Investment</option>
                            <option value="fixed_deposit" {{ old('account_type', $account->account_type) === 'fixed_deposit' ? 'selected' : '' }}>Fixed Deposit</option>
                            <option value="offshore" {{ old('account_type', $account->account_type) === 'offshore' ? 'selected' : '' }}>Offshore</option>
                        </flux:select>
                        <flux:error name="account_type" />
                    </flux:field>

                    <!-- Account Name -->
                    <flux:field>
                        <flux:label>Account Name</flux:label>
                        <flux:input 
                            name="account_name" 
                            value="{{ old('account_name', $account->account_name) }}" 
                            placeholder="Enter account name"
                        />
                        <flux:error name="account_name" />
                    </flux:field>

                    <!-- Currency -->
                    <flux:field>
                        <flux:label>Currency</flux:label>
                        <flux:select name="currency">
                            <option value="USD" {{ old('currency', $account->currency) === 'USD' ? 'selected' : '' }}>USD</option>
                            <option value="EUR" {{ old('currency', $account->currency) === 'EUR' ? 'selected' : '' }}>EUR</option>
                            <option value="GBP" {{ old('currency', $account->currency) === 'GBP' ? 'selected' : '' }}>GBP</option>
                        </flux:select>
                        <flux:error name="currency" />
                    </flux:field>

                    <!-- Description -->
                    <flux:field class="md:col-span-2">
                        <flux:label>Description</flux:label>
                        <flux:textarea 
                            name="description" 
                            placeholder="Enter account description"
                        >{{ old('description', $account->description) }}</flux:textarea>
                        <flux:error name="description" />
                    </flux:field>
                </div>
            </div>

            <!-- Balance Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Balance Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Current Balance -->
                    <flux:field>
                        <flux:label>Current Balance</flux:label>
                        <flux:input 
                            name="balance" 
                            type="number"
                            step="0.01"
                            value="{{ old('balance', $account->balance) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="balance" />
                    </flux:field>

                    <!-- Available Balance -->
                    <flux:field>
                        <flux:label>Available Balance</flux:label>
                        <flux:input 
                            name="available_balance" 
                            type="number"
                            step="0.01"
                            value="{{ old('available_balance', $account->available_balance) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="available_balance" />
                    </flux:field>

                    <!-- Hold Balance -->
                    <flux:field>
                        <flux:label>Hold Balance</flux:label>
                        <flux:input 
                            name="hold_balance" 
                            type="number"
                            step="0.01"
                            value="{{ old('hold_balance', $account->hold_balance) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="hold_balance" />
                    </flux:field>
                </div>
            </div>

            <!-- Transaction Limits -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Transaction Limits</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Daily Transfer Limit -->
                    <flux:field>
                        <flux:label>Daily Transfer Limit</flux:label>
                        <flux:input 
                            name="daily_transfer_limit" 
                            type="number"
                            step="0.01"
                            value="{{ old('daily_transfer_limit', $account->daily_transfer_limit) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="daily_transfer_limit" />
                    </flux:field>

                    <!-- Monthly Transfer Limit -->
                    <flux:field>
                        <flux:label>Monthly Transfer Limit</flux:label>
                        <flux:input 
                            name="monthly_transfer_limit" 
                            type="number"
                            step="0.01"
                            value="{{ old('monthly_transfer_limit', $account->monthly_transfer_limit) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="monthly_transfer_limit" />
                    </flux:field>

                    <!-- Daily Withdrawal Limit -->
                    <flux:field>
                        <flux:label>Daily Withdrawal Limit</flux:label>
                        <flux:input 
                            name="daily_withdrawal_limit" 
                            type="number"
                            step="0.01"
                            value="{{ old('daily_withdrawal_limit', $account->daily_withdrawal_limit) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="daily_withdrawal_limit" />
                    </flux:field>

                    <!-- Monthly Withdrawal Limit -->
                    <flux:field>
                        <flux:label>Monthly Withdrawal Limit</flux:label>
                        <flux:input 
                            name="monthly_withdrawal_limit" 
                            type="number"
                            step="0.01"
                            value="{{ old('monthly_withdrawal_limit', $account->monthly_withdrawal_limit) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="monthly_withdrawal_limit" />
                    </flux:field>
                </div>
            </div>

            <!-- Account Status -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Status</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Status -->
                    <flux:field>
                        <flux:label>Status</flux:label>
                        <flux:select name="status">
                            <option value="active" {{ old('status', $account->status) === 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status', $account->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                            <option value="suspended" {{ old('status', $account->status) === 'suspended' ? 'selected' : '' }}>Suspended</option>
                            <option value="frozen" {{ old('status', $account->status) === 'frozen' ? 'selected' : '' }}>Frozen</option>
                            <option value="closed" {{ old('status', $account->status) === 'closed' ? 'selected' : '' }}>Closed</option>
                            <option value="pending" {{ old('status', $account->status) === 'pending' ? 'selected' : '' }}>Pending</option>
                        </flux:select>
                        <flux:error name="status" />
                    </flux:field>

                    <!-- Verification Status -->
                    <flux:field>
                        <flux:label>Verification Status</flux:label>
                        <flux:select name="verification_status">
                            <option value="pending" {{ old('verification_status', $account->verification_status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="verified" {{ old('verification_status', $account->verification_status) === 'verified' ? 'selected' : '' }}>Verified</option>
                            <option value="rejected" {{ old('verification_status', $account->verification_status) === 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </flux:select>
                        <flux:error name="verification_status" />
                    </flux:field>

                    <!-- Risk Level -->
                    <flux:field>
                        <flux:label>Risk Level</flux:label>
                        <flux:select name="risk_level">
                            <option value="low" {{ old('risk_level', $account->risk_level) === 'low' ? 'selected' : '' }}>Low</option>
                            <option value="medium" {{ old('risk_level', $account->risk_level) === 'medium' ? 'selected' : '' }}>Medium</option>
                            <option value="high" {{ old('risk_level', $account->risk_level) === 'high' ? 'selected' : '' }}>High</option>
                        </flux:select>
                        <flux:error name="risk_level" />
                    </flux:field>

                    <!-- Risk Tolerance -->
                    <flux:field>
                        <flux:label>Risk Tolerance</flux:label>
                        <flux:select name="risk_tolerance">
                            <option value="">Select Risk Tolerance</option>
                            <option value="conservative" {{ old('risk_tolerance', $account->risk_tolerance) === 'conservative' ? 'selected' : '' }}>Conservative</option>
                            <option value="moderate" {{ old('risk_tolerance', $account->risk_tolerance) === 'moderate' ? 'selected' : '' }}>Moderate</option>
                            <option value="aggressive" {{ old('risk_tolerance', $account->risk_tolerance) === 'aggressive' ? 'selected' : '' }}>Aggressive</option>
                        </flux:select>
                        <flux:error name="risk_tolerance" />
                    </flux:field>
                </div>
            </div>

            <!-- Interest and Fees -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Interest and Fees</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Interest Rate -->
                    <flux:field>
                        <flux:label>Interest Rate (%)</flux:label>
                        <flux:input 
                            name="interest_rate" 
                            type="number"
                            step="0.0001"
                            min="0"
                            max="1"
                            value="{{ old('interest_rate', $account->interest_rate) }}" 
                            placeholder="0.0000"
                        />
                        <flux:error name="interest_rate" />
                    </flux:field>

                    <!-- Interest Frequency -->
                    <flux:field>
                        <flux:label>Interest Frequency</flux:label>
                        <flux:select name="interest_frequency">
                            <option value="">Select Frequency</option>
                            <option value="monthly" {{ old('interest_frequency', $account->interest_frequency) === 'monthly' ? 'selected' : '' }}>Monthly</option>
                            <option value="quarterly" {{ old('interest_frequency', $account->interest_frequency) === 'quarterly' ? 'selected' : '' }}>Quarterly</option>
                            <option value="annually" {{ old('interest_frequency', $account->interest_frequency) === 'annually' ? 'selected' : '' }}>Annually</option>
                        </flux:select>
                        <flux:error name="interest_frequency" />
                    </flux:field>

                    <!-- Monthly Maintenance Fee -->
                    <flux:field>
                        <flux:label>Monthly Maintenance Fee</flux:label>
                        <flux:input 
                            name="monthly_maintenance_fee" 
                            type="number"
                            step="0.01"
                            value="{{ old('monthly_maintenance_fee', $account->monthly_maintenance_fee) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="monthly_maintenance_fee" />
                    </flux:field>

                    <!-- Overdraft Limit -->
                    <flux:field>
                        <flux:label>Overdraft Limit</flux:label>
                        <flux:input 
                            name="overdraft_limit" 
                            type="number"
                            step="0.01"
                            value="{{ old('overdraft_limit', $account->overdraft_limit) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="overdraft_limit" />
                    </flux:field>

                    <!-- Overdraft Fee -->
                    <flux:field>
                        <flux:label>Overdraft Fee</flux:label>
                        <flux:input 
                            name="overdraft_fee" 
                            type="number"
                            step="0.01"
                            value="{{ old('overdraft_fee', $account->overdraft_fee) }}" 
                            placeholder="0.00"
                        />
                        <flux:error name="overdraft_fee" />
                    </flux:field>
                </div>
            </div>

            <!-- Account Features -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Features</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Online Banking -->
                    <flux:field>
                        <flux:label>Online Banking</flux:label>
                        <flux:select name="online_banking_enabled">
                            <option value="1" {{ old('online_banking_enabled', $account->online_banking_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('online_banking_enabled', $account->online_banking_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="online_banking_enabled" />
                    </flux:field>

                    <!-- Mobile Banking -->
                    <flux:field>
                        <flux:label>Mobile Banking</flux:label>
                        <flux:select name="mobile_banking_enabled">
                            <option value="1" {{ old('mobile_banking_enabled', $account->mobile_banking_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('mobile_banking_enabled', $account->mobile_banking_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="mobile_banking_enabled" />
                    </flux:field>

                    <!-- Debit Card -->
                    <flux:field>
                        <flux:label>Debit Card</flux:label>
                        <flux:select name="debit_card_enabled">
                            <option value="1" {{ old('debit_card_enabled', $account->debit_card_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('debit_card_enabled', $account->debit_card_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="debit_card_enabled" />
                    </flux:field>

                    <!-- Credit Card -->
                    <flux:field>
                        <flux:label>Credit Card</flux:label>
                        <flux:select name="credit_card_enabled">
                            <option value="1" {{ old('credit_card_enabled', $account->credit_card_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('credit_card_enabled', $account->credit_card_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="credit_card_enabled" />
                    </flux:field>

                    <!-- International Transfers -->
                    <flux:field>
                        <flux:label>International Transfers</flux:label>
                        <flux:select name="international_transfers_enabled">
                            <option value="1" {{ old('international_transfers_enabled', $account->international_transfers_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('international_transfers_enabled', $account->international_transfers_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="international_transfers_enabled" />
                    </flux:field>

                    <!-- Investment Trading -->
                    <flux:field>
                        <flux:label>Investment Trading</flux:label>
                        <flux:select name="investment_trading_enabled">
                            <option value="1" {{ old('investment_trading_enabled', $account->investment_trading_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('investment_trading_enabled', $account->investment_trading_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="investment_trading_enabled" />
                    </flux:field>

                    <!-- Two-Factor Authentication -->
                    <flux:field>
                        <flux:label>Two-Factor Authentication</flux:label>
                        <flux:select name="two_factor_required">
                            <option value="1" {{ old('two_factor_required', $account->two_factor_required ? '1' : '0') === '1' ? 'selected' : '' }}>Required</option>
                            <option value="0" {{ old('two_factor_required', $account->two_factor_required ? '1' : '0') === '0' ? 'selected' : '' }}>Optional</option>
                        </flux:select>
                        <flux:error name="two_factor_required" />
                    </flux:field>

                    <!-- Biometric Authentication -->
                    <flux:field>
                        <flux:label>Biometric Authentication</flux:label>
                        <flux:select name="biometric_required">
                            <option value="1" {{ old('biometric_required', $account->biometric_required ? '1' : '0') === '1' ? 'selected' : '' }}>Required</option>
                            <option value="0" {{ old('biometric_required', $account->biometric_required ? '1' : '0') === '0' ? 'selected' : '' }}>Optional</option>
                        </flux:select>
                        <flux:error name="biometric_required" />
                    </flux:field>

                    <!-- AML Monitoring -->
                    <flux:field>
                        <flux:label>AML Monitoring</flux:label>
                        <flux:select name="aml_monitoring_enabled">
                            <option value="1" {{ old('aml_monitoring_enabled', $account->aml_monitoring_enabled ? '1' : '0') === '1' ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ old('aml_monitoring_enabled', $account->aml_monitoring_enabled ? '1' : '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="aml_monitoring_enabled" />
                    </flux:field>
                </div>
            </div>

            <!-- Master Account Settings -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Master Account Settings</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Is Master Account -->
                    <flux:field>
                        <flux:label>Master Account</flux:label>
                        <flux:select name="is_master_account">
                            <option value="1" {{ old('is_master_account', $account->is_master_account ? '1' : '0') === '1' ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ old('is_master_account', $account->is_master_account ? '1' : '0') === '0' ? 'selected' : '' }}>No</option>
                        </flux:select>
                        <flux:error name="is_master_account" />
                    </flux:field>

                    <!-- Parent Account -->
                    <flux:field>
                        <flux:label>Parent Account</flux:label>
                        <flux:select name="parent_account_id">
                            <option value="">No Parent Account</option>
                            @foreach($parentAccounts as $parentAccount)
                                <option value="{{ $parentAccount->id }}" {{ old('parent_account_id', $account->parent_account_id) == $parentAccount->id ? 'selected' : '' }}>
                                    {{ $parentAccount->account_number }} - {{ $parentAccount->account_name }}
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="parent_account_id" />
                    </flux:field>
                </div>
            </div>

            <!-- Business Information (conditional) -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6" id="business-info" style="display: none;">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Business Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Business Name -->
                    <flux:field>
                        <flux:label>Business Name</flux:label>
                        <flux:input 
                            name="business_name" 
                            value="{{ old('business_name', $account->business_name) }}" 
                            placeholder="Enter business name"
                        />
                        <flux:error name="business_name" />
                    </flux:field>

                    <!-- Business Type -->
                    <flux:field>
                        <flux:label>Business Type</flux:label>
                        <flux:input 
                            name="business_type" 
                            value="{{ old('business_type', $account->business_type) }}" 
                            placeholder="Enter business type"
                        />
                        <flux:error name="business_type" />
                    </flux:field>

                    <!-- Business Registration Number -->
                    <flux:field>
                        <flux:label>Business Registration Number</flux:label>
                        <flux:input 
                            name="business_registration_number" 
                            value="{{ old('business_registration_number', $account->business_registration_number) }}" 
                            placeholder="Enter registration number"
                        />
                        <flux:error name="business_registration_number" />
                    </flux:field>

                    <!-- Tax Identification Number -->
                    <flux:field>
                        <flux:label>Tax Identification Number</flux:label>
                        <flux:input 
                            name="tax_identification_number" 
                            value="{{ old('tax_identification_number', $account->tax_identification_number) }}" 
                            placeholder="Enter tax ID"
                        />
                        <flux:error name="tax_identification_number" />
                    </flux:field>
                </div>
            </div>

            <!-- Investment Information (conditional) -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6" id="investment-info" style="display: none;">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Investment Information</h3>
                <div class="space-y-6">
                    <!-- Investment Strategy -->
                    <flux:field>
                        <flux:label>Investment Strategy</flux:label>
                        <flux:textarea 
                            name="investment_strategy" 
                            placeholder="Enter investment strategy"
                        >{{ old('investment_strategy', $account->investment_strategy) }}</flux:textarea>
                        <flux:error name="investment_strategy" />
                    </flux:field>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex justify-end space-x-3">
                <flux:button href="{{ route('admin.accounts.show', $account) }}" variant="outline">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" variant="primary">
                    Update Account
                </flux:button>
            </div>
        </form>
    </div>

    <script>
        // Show/hide business information based on account type
        document.addEventListener('DOMContentLoaded', function() {
            const accountTypeSelect = document.querySelector('select[name="account_type"]');
            const businessInfo = document.getElementById('business-info');
            const investmentInfo = document.getElementById('investment-info');

            function toggleSections() {
                const accountType = accountTypeSelect.value;
                
                if (accountType === 'business') {
                    businessInfo.style.display = 'block';
                } else {
                    businessInfo.style.display = 'none';
                }

                if (accountType === 'investment') {
                    investmentInfo.style.display = 'block';
                } else {
                    investmentInfo.style.display = 'none';
                }
            }

            // Initial check
            toggleSections();

            // Listen for changes
            accountTypeSelect.addEventListener('change', toggleSections);
        });
    </script>
@endsection
