@extends('layouts.public')

@section('content')
<!-- Hero Section -->
<section class="relative h-96 bg-cover bg-center bg-no-repeat" style="background-image: url('/Frontend/images/background/8.jpg');">
    <div class="absolute inset-0 bg-black opacity-50"></div>
    <div class="relative z-10 h-full flex items-center">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full">
            <div class="flex items-center">
                <!-- Blue separator line -->
                <div class="w-1 h-12 bg-[#303ffa] mr-4"></div>
                <div>
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">About Us</h1>
                    <nav class="text-white text-sm">
                        <a href="{{ route('home') }}" class="hover:text-gray-300">Home</a>
                        <span class="mx-2">></span>
                        <span class="text-gray-300">Pages</span>
                        <span class="mx-2">></span>
                        <span class="text-gray-300">About Us</span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Content Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-16">
            <div class="text-sm font-semibold text-gray-500 uppercase tracking-wide mb-4">ABOUT US</div>
            <h2 class="text-2xl md:text-3xl lg:text-4xl font-bold text-[#1e3a8a] mb-6">
                We are here to manage your finance with 
                <span class="text-[#465ba9]">experience</span>
            </h2>
            <div class="w-16 h-1 bg-[#1e3a8a] mx-auto"></div>
        </div>

        <!-- Two Column Layout -->
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <!-- Left Column - Image -->
            <div class="relative">
                <div class="relative">
                    <img 
                        src="/Frontend/images/resource/video-img.jpg" 
                        alt="Professional team discussing" 
                        class="w-full h-96 object-cover rounded-lg shadow-lg"
                    >
                    <!-- Dotted pattern overlay -->
                    <div class="absolute -left-4 top-0 w-4 h-full bg-repeat-y opacity-20" style="background-image: radial-gradient(circle, #1e3a8a 1px, transparent 1px); background-size: 8px 8px;"></div>
                </div>
            </div>

            <!-- Right Column - Text Content -->
            <div class="space-y-6">
                <div class="prose prose-lg max-w-none">
                    <p class="text-gray-700 leading-relaxed lg:text-lg text-base">
                        At {{ \App\Helpers\SettingsHelper::bankName() }}, we value the relationships we have built since 1980. We are committed to providing unmatched service, competitive products, and a focus on relationships that set us apart from other financial institutions. Our growth has been driven by our desire to satisfy the demand for service, and today we operate 211 full-service banking locations and 19 loan origination offices with over 3,000 employees.
                    </p>
                </div>
                
                <div class="prose prose-lg max-w-none">
                    <p class="text-gray-700 leading-relaxed lg:text-lg text-base">
                        Our history of safe, sound, and secure banking practices has enabled us to navigate through various economic changes and challenges. We have consistently maintained our commitment to our core values while adapting to meet the evolving needs of our customers. Our employees, customers, shareholders, and communities can rely on us as their banking partner for decades to come.
                    </p>
                </div>

                <!-- Key Statistics -->
                <div class="grid grid-cols-2 gap-6 pt-6">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-[#1e3a8a] mb-2">211+</div>
                        <div class="text-sm text-gray-600">Banking Locations</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-[#1e3a8a] mb-2">3,000+</div>
                        <div class="text-sm text-gray-600">Employees</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-[#1e3a8a] mb-2">19</div>
                        <div class="text-sm text-gray-600">Loan Offices</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-[#1e3a8a] mb-2">40+</div>
                        <div class="text-sm text-gray-600">Years Experience</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mission & Values Section -->
<section class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h3 class="text-3xl md:text-4xl font-bold text-[#1e3a8a] mb-4">Our Mission & Values</h3>
            <div class="w-16 h-1 bg-[#1e3a8a] mx-auto"></div>
        </div>

        <div class="grid md:grid-cols-3 gap-8">
            <!-- Mission -->
            <div class="text-center">
                <div class="w-16 h-16 bg-[#1e3a8a] rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h4 class="text-xl font-bold text-[#1e3a8a] mb-3">Our Mission</h4>
                <p class="text-gray-600">To provide exceptional financial services that empower our customers to achieve their goals and build stronger communities.</p>
            </div>

            <!-- Vision -->
            <div class="text-center">
                <div class="w-16 h-16 bg-[#1e3a8a] rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
                <h4 class="text-xl font-bold text-[#1e3a8a] mb-3">Our Vision</h4>
                <p class="text-gray-600">To be the most trusted and innovative financial partner, recognized for our integrity, excellence, and community commitment.</p>
            </div>

            <!-- Values -->
            <div class="text-center">
                <div class="w-16 h-16 bg-[#1e3a8a] rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                </div>
                <h4 class="text-xl font-bold text-[#1e3a8a] mb-3">Our Values</h4>
                <p class="text-gray-600">Integrity, excellence, innovation, and community commitment guide everything we do in serving our customers.</p>
            </div>
        </div>
    </div>
</section>

@endsection
