// Fortis Elite Finance Bank - Main JavaScript File

// Import dependencies
import $ from 'jquery';
import 'select2/dist/css/select2.css';
import Chart from 'chart.js/auto';

// WebAuthn/Passkey Support
import {
    browserSupportsWebAuthn,
    startAuthentication,
    startRegistration,
} from '@simplewebauthn/browser'

// Make jQuery and Select2 globally available
window.$ = window.jQuery = $;

// Make WebAuthn functions globally available
window.browserSupportsWebAuthn = browserSupportsWebAuthn;
window.startAuthentication = startAuthentication;
window.startRegistration = startRegistration;

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2 for all select elements with .select2 class
    if (typeof $.fn.select2 !== 'undefined') {
        $('.select2').select2({
            theme: 'default',
            width: '100%'
        });
    }

    // Initialize Chart.js defaults for banking charts
    if (typeof Chart !== 'undefined') {
        Chart.defaults.color = '#6b7280'; // Tailwind gray-500
        Chart.defaults.borderColor = '#e5e7eb'; // Tailwind gray-200
        Chart.defaults.font.family = 'Instrument Sans, ui-sans-serif, system-ui, sans-serif';
        
        // Banking-specific chart colors
        Chart.defaults.plugins.colors = {
            forceOverride: true,
            schemes: {
                banking: [
                    '#3b82f6', // blue-500
                    '#10b981', // emerald-500
                    '#f59e0b', // amber-500
                    '#ef4444', // red-500
                    '#8b5cf6', // violet-500
                    '#06b6d4', // cyan-500
                    '#84cc16', // lime-500
                    '#f97316'  // orange-500
                ]
            }
        };
    }
});

// Sidebar functionality
function initializeSidebar() {
    // Remove existing event handlers to prevent duplicates
    $('#toggleMobileSidebar').off('click');
    $('#closeMobileSidebar, #mobileOverlay').off('click');
    $('.sidebar-link').off('click');
    
    // Mobile sidebar toggle
    $('#toggleMobileSidebar').on('click', function() {
        $('#sidebar').removeClass('-translate-x-full').addClass('translate-x-0');
        $('#mobileOverlay').removeClass('hidden');
    });

    // Close mobile sidebar
    $('#closeMobileSidebar, #mobileOverlay').on('click', function() {
        $('#sidebar').removeClass('translate-x-0').addClass('-translate-x-full');
        $('#mobileOverlay').addClass('hidden');
    });

    // Close mobile sidebar when clicking on navigation links
    $('.sidebar-link').on('click', function() {
        if (window.innerWidth < 768) { // Only on mobile
            $('#sidebar').removeClass('translate-x-0').addClass('-translate-x-full');
            $('#mobileOverlay').addClass('hidden');
        }
    });
}

$(document).ready(function() {
    initializeSidebar();
    
    // Handle window resize
    $(window).on('resize', function() {
        if (window.innerWidth >= 768) {
            $('#mobileOverlay').addClass('hidden');
        }
    });
});

// Reinitialize sidebar functionality after Livewire navigation
document.addEventListener('livewire:navigated', function() {
    initializeSidebar();
});

// Export for use in other modules
export { Chart };
