<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Account;
use App\Models\UserProfile;
use Illuminate\Support\Facades\Hash;

class TestAdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a test super admin user
        $superAdmin = User::create([
            'name' => 'Super Admin',
            'email' => 'admin@fortisbank.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'customer_id' => '00000001',
            'customer_type' => 'individual',
            'pin' => '123456',
            'customer_status' => 'active',
            'account_activated_at' => now(),
        ]);

        // Assign super-admin role
        $superAdmin->assignRole('super-admin');

        // Create a test admin user
        $admin = User::create([
            'name' => 'Bank Admin',
            'email' => 'bankadmin@fortisbank.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'customer_id' => '00000002',
            'customer_type' => 'individual',
            'pin' => '123456',
            'customer_status' => 'active',
            'account_activated_at' => now(),
        ]);

        // Assign admin role
        $admin->assignRole('admin');

        // Create a test customer user
        $customer = User::create([
            'name' => 'John Customer',
            'email' => 'customer@fortisbank.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'customer_id' => '00000003',
            'customer_type' => 'individual',
            'pin' => '123456',
            'customer_status' => 'active',
            'account_activated_at' => now(),
        ]);

        // Assign customer role
        $customer->assignRole('customer');

        // Create user profile for customer
        $customerProfile = UserProfile::create([
            'user_id' => $customer->id,
            'first_name' => 'John',
            'last_name' => 'Customer',
            'middle_name' => null,
            'date_of_birth' => '1990-01-01',
            'gender' => 'male',
            'marital_status' => 'single',
            'city' => 'New York',
            'address_line_1' => '123 Main Street',
            'postal_code' => '10001',
            'state_province' => 'NY',
            'country' => 'US',
            'phone_number' => '+1-555-0123',
            'occupation' => 'Business Owner',
            'annual_income' => 1000000.00,
            'preferred_language' => 'en',
            'timezone' => 'UTC',
            'kyc_status' => 'verified',
            'kyc_verified_at' => now(),
            'aml_status' => 'clear',
            'compliance_status' => 'compliant',
        ]);

        // Create main account for customer
        $mainAccount = Account::create([
            'user_id' => $customer->id,
            'account_number' => '7473669095',
            'account_type' => 'offshore',
            'currency' => 'EUR',
            'balance' => 31221374.00,
            'available_balance' => 31221374.00,
            'hold_balance' => 0.00,
            'daily_transfer_limit' => 1000000.00,
            'monthly_transfer_limit' => 10000000.00,
            'daily_withdrawal_limit' => 500000.00,
            'monthly_withdrawal_limit' => 5000000.00,
            'status' => 'active',
            'verification_status' => 'verified',
            'activated_at' => now(),
        ]);

        // Create business account for customer (if they were business type)
        if ($customer->customer_type === 'business') {
            $businessAccount = Account::create([
                'user_id' => $customer->id,
                'account_number' => '7473669096',
                'account_type' => 'business',
                'currency' => 'EUR',
                'balance' => 5000000.00,
                'available_balance' => 5000000.00,
                'hold_balance' => 0.00,
                'daily_transfer_limit' => 2000000.00,
                'monthly_transfer_limit' => 20000000.00,
                'daily_withdrawal_limit' => 1000000.00,
                'monthly_withdrawal_limit' => 10000000.00,
                'status' => 'active',
                'verification_status' => 'verified',
                'activated_at' => now(),
                'business_name' => 'Customer Business Ltd',
                'business_type' => 'corporation',
                'business_registration_number' => 'BR123456789',
                'tax_identification_number' => 'TAX987654321',
            ]);
        }

        $this->command->info('Test users created successfully!');
        $this->command->info('Super Admin: admin@fortisbank.com / password');
        $this->command->info('Bank Admin: bankadmin@fortisbank.com / password');
        $this->command->info('Customer: customer@fortisbank.com / password');
        $this->command->info('Customer Account: 7473669095 (€31,221,374.00)');
    }
}
