<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Bank Settings
        Setting::set('bank_name', 'Cycloverse Bank', 'string', 'bank', 'Official bank name', true);
        Setting::set('bank_code', 'CYB', 'string', 'bank', 'Bank identification code', true);
        Setting::set('swift_code', 'CYBKENA', 'string', 'bank', 'SWIFT/BIC code for international transfers', true);
        Setting::set('bank_address', 'Nairobi, Kenya', 'string', 'bank', 'Bank headquarters address', true);
        Setting::set('phone_number', '+254 700 000 000', 'string', 'bank', 'Main contact phone number', true);
        Setting::set('email', 'info@cycloversebank.com', 'string', 'bank', 'Main contact email', true);
        Setting::set('website', 'https://bank.cycloverseworld.info', 'string', 'bank', 'Bank website URL', true);
        Setting::set('currency', 'USD', 'string', 'bank', 'Default currency', true);
        Setting::set('timezone', 'UTC', 'string', 'bank', 'Bank timezone', true);
        Setting::set('logo_url', '/images/logo.png', 'string', 'bank', 'Bank logo URL', true);
        Setting::set('support_email', 'support@cycloversebank.com', 'string', 'bank', 'Customer support email', true);
        Setting::set('compliance_email', 'compliance@cycloversebank.com', 'string', 'bank', 'Compliance department email', true);

        // Transaction Limits
        Setting::set('daily_transfer_limit', '10000.00', 'float', 'limits', 'Maximum daily transfer amount', false);
        Setting::set('monthly_transfer_limit', '100000.00', 'float', 'limits', 'Maximum monthly transfer amount', false);
        Setting::set('daily_withdrawal_limit', '5000.00', 'float', 'limits', 'Maximum daily withdrawal amount', false);
        Setting::set('monthly_withdrawal_limit', '50000.00', 'float', 'limits', 'Maximum monthly withdrawal amount', false);
        Setting::set('max_transaction_amount', '50000.00', 'float', 'limits', 'Maximum single transaction amount', false);
        Setting::set('min_transaction_amount', '1.00', 'float', 'limits', 'Minimum single transaction amount', false);
        Setting::set('max_daily_transactions', '50', 'integer', 'limits', 'Maximum daily transaction count', false);
        Setting::set('max_monthly_transactions', '500', 'integer', 'limits', 'Maximum monthly transaction count', false);
        Setting::set('international_transfer_limit', '25000.00', 'float', 'limits', 'Maximum international transfer amount', false);
        Setting::set('domestic_transfer_limit', '10000.00', 'float', 'limits', 'Maximum domestic transfer amount', false);

        // Compliance Settings
        Setting::set('kyc_required', '1', 'boolean', 'compliance', 'Require KYC verification for all customers', false);
        Setting::set('kyc_verification_required', '1', 'boolean', 'compliance', 'Require manual verification of KYC documents', false);
        Setting::set('aml_monitoring', '1', 'boolean', 'compliance', 'Enable anti-money laundering monitoring', false);
        Setting::set('transaction_monitoring', '1', 'boolean', 'compliance', 'Monitor transactions for suspicious activity', false);
        Setting::set('suspicious_activity_threshold', '10000.00', 'float', 'compliance', 'Amount threshold for flagging suspicious activity', false);
        Setting::set('high_risk_countries', '[]', 'array', 'compliance', 'Countries flagged as high risk for money laundering', false);
        Setting::set('sanctioned_countries', '[]', 'array', 'compliance', 'Countries under international sanctions', false);
        Setting::set('pep_screening', '1', 'boolean', 'compliance', 'Screen for Politically Exposed Persons (PEP)', false);
        Setting::set('adverse_media_screening', '1', 'boolean', 'compliance', 'Screen for adverse media mentions', false);
        Setting::set('compliance_retention_days', '2555', 'integer', 'compliance', 'Number of days to retain compliance data (7 years)', false);
        Setting::set('auto_approve_kyc', '0', 'boolean', 'compliance', 'Automatically approve KYC for low-risk customers', false);
        Setting::set('kyc_auto_approve_threshold', '1000.00', 'float', 'compliance', 'Transaction amount threshold for auto-approval', false);

        // Notification Settings
        Setting::set('email_notifications', '1', 'boolean', 'notifications', 'Enable email notifications', false);
        Setting::set('sms_notifications', '1', 'boolean', 'notifications', 'Enable SMS notifications', false);
        Setting::set('push_notifications', '1', 'boolean', 'notifications', 'Enable push notifications', false);
        Setting::set('transaction_alerts', '1', 'boolean', 'notifications', 'Send alerts for transaction activities', false);
        Setting::set('security_alerts', '1', 'boolean', 'notifications', 'Send alerts for security events', false);
        Setting::set('compliance_alerts', '1', 'boolean', 'notifications', 'Send alerts for compliance issues', false);
        Setting::set('kyc_notifications', '1', 'boolean', 'notifications', 'Send notifications for KYC status changes', false);
        Setting::set('admin_notifications', '1', 'boolean', 'notifications', 'Enable notifications for admin activities', false);
        Setting::set('smtp_host', 'smtp.gmail.com', 'string', 'notifications', 'SMTP server hostname', false);
        Setting::set('smtp_port', '587', 'integer', 'notifications', 'SMTP server port', false);
        Setting::set('smtp_username', '', 'string', 'notifications', 'SMTP username', false);
        Setting::set('smtp_password', '', 'string', 'notifications', 'SMTP password', false);
        Setting::set('sms_provider', 'twilio', 'string', 'notifications', 'SMS service provider', false);
        Setting::set('sms_api_key', '', 'string', 'notifications', 'SMS API key', false);
        Setting::set('sms_api_secret', '', 'string', 'notifications', 'SMS API secret', false);

        // System Settings
        Setting::set('maintenance_mode', '0', 'boolean', 'system', 'Enable maintenance mode', true);
        Setting::set('debug_mode', '0', 'boolean', 'system', 'Enable debug mode', false);
        Setting::set('session_lifetime', '120', 'integer', 'system', 'Session lifetime in minutes', false);
        Setting::set('password_min_length', '8', 'integer', 'system', 'Minimum password length', false);
        Setting::set('password_require_special', '1', 'boolean', 'system', 'Require special characters in passwords', false);
        Setting::set('password_require_numbers', '1', 'boolean', 'system', 'Require numbers in passwords', false);
        Setting::set('password_require_uppercase', '1', 'boolean', 'system', 'Require uppercase letters in passwords', false);
        Setting::set('login_attempts', '5', 'integer', 'system', 'Maximum login attempts before lockout', false);
        Setting::set('lockout_duration', '15', 'integer', 'system', 'Account lockout duration in minutes', false);
        Setting::set('two_factor_required', '0', 'boolean', 'system', 'Require two-factor authentication', false);
        Setting::set('api_rate_limit', '60', 'integer', 'system', 'API rate limit (requests per minute)', false);
        Setting::set('backup_frequency', 'daily', 'string', 'system', 'Backup frequency', false);
        Setting::set('backup_retention', '30', 'integer', 'system', 'Backup retention in days', false);
        Setting::set('log_retention', '90', 'integer', 'system', 'Log retention in days', false);
    }
}
