<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('codes', function (Blueprint $table) {
            // Add allow columns
            $table->boolean('allow_local')->default(false);
            $table->boolean('allow_international')->default(false);
            
            // Update status columns to use boolean instead of enum
            $table->dropColumn(['cot_status', 'tax_status', 'imf_status']);
        });
        
        Schema::table('codes', function (Blueprint $table) {
            $table->boolean('cot_status')->default(false);
            $table->boolean('tax_status')->default(false);
            $table->boolean('imf_status')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('codes', function (Blueprint $table) {
            $table->dropColumn(['allow_local', 'allow_international', 'cot_status', 'tax_status', 'imf_status']);
        });
        
        Schema::table('codes', function (Blueprint $table) {
            $table->enum('cot_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->enum('tax_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->enum('imf_status', ['pending', 'approved', 'rejected'])->default('pending');
        });
    }
};
