<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('cot_code')->nullable();
            $table->enum('cot_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('cot_msg')->nullable();
            $table->string('tax_code')->nullable();
            $table->enum('tax_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('tax_msg')->nullable();
            $table->string('imf_code')->nullable();
            $table->enum('imf_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('imf_msg')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codes');
    }
};
