<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cache', function (Blueprint $table) {
            // Enhanced cache management
            $table->string('cache_type')->nullable()->after('value'); // session, data, query, view
            $table->string('cache_group')->nullable()->after('cache_type'); // user, system, public, admin
            $table->integer('access_count')->default(0)->after('cache_group'); // Track cache hits
            $table->timestamp('last_accessed_at')->nullable()->after('access_count');
            $table->timestamp('expires_at')->nullable()->after('last_accessed_at'); // Custom expiration
            $table->enum('priority', ['low', 'normal', 'high', 'critical'])->default('normal')->after('expires_at');
            $table->boolean('compressed')->default(false)->after('priority'); // Whether value is compressed
            $table->string('checksum')->nullable()->after('compressed'); // Data integrity check
            $table->json('metadata')->nullable()->after('checksum'); // Additional cache metadata
            
            // Indexes for performance
            $table->index(['cache_type', 'cache_group']);
            $table->index(['expires_at']);
            $table->index(['priority']);
            $table->index(['last_accessed_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cache', function (Blueprint $table) {
            $table->dropIndex(['cache_type', 'cache_group']);
            $table->dropIndex(['expires_at']);
            $table->dropIndex(['priority']);
            $table->dropIndex(['last_accessed_at']);
            
            $table->dropColumn([
                'cache_type',
                'cache_group', 
                'access_count',
                'last_accessed_at',
                'expires_at',
                'priority',
                'compressed',
                'checksum',
                'metadata'
            ]);
        });
    }
};
