<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // Add global middleware
        $middleware->append(\App\Http\Middleware\ErrorHandlingMiddleware::class);
        $middleware->web(append: [
            \App\Http\Middleware\CheckBlockedUser::class,
        ]);
        
        // Override the default maintenance mode middleware
        $middleware->replace(
            \Illuminate\Foundation\Http\Middleware\PreventRequestsDuringMaintenance::class,
            \App\Http\Middleware\PreventRequestsDuringMaintenance::class
        );
        
        $middleware->alias([
            'role' => \App\Http\Middleware\CheckRole::class,
            'profile.complete' => \App\Http\Middleware\RequireProfileCompletion::class,
            'allow.2fa.users' => \App\Http\Middleware\Allow2FAUsers::class,
            'admin.auth' => \App\Http\Middleware\AdminAuth::class,
            'admin.guest' => \App\Http\Middleware\AdminRedirectIfAuthenticated::class,
            'kyc.required' => \App\Http\Middleware\KycVerificationMiddleware::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
