<?php

namespace App\Services;

use App\Models\User;
use App\Models\Account;
use App\Models\Transaction;
use App\Models\VirtualCard;
use App\Models\KycDocument;
use App\Models\ComplianceLog;

class SidebarCountService
{
    /**
     * Get all sidebar counts
     */
    public static function getCounts(): array
    {
        return [
            'users' => self::getUserCount(),
            'accounts' => self::getAccountCount(),
            'transactions' => self::getTransactionCount(),
            'transfers' => self::getTransferCount(),
            'deposits' => self::getDepositCount(),
            'virtual_cards' => self::getVirtualCardCount(),
            'kyc' => self::getKycCount(),
            'compliance' => self::getComplianceCount(),
        ];
    }

    /**
     * Get pending user verification count
     */
    public static function getUserCount(): int
    {
        return User::where('customer_status', 'pending_verification')->count();
    }

    /**
     * Get pending account count
     */
    public static function getAccountCount(): int
    {
        return Account::where('status', 'pending')->count();
    }

    /**
     * Get pending transaction count
     */
    public static function getTransactionCount(): int
    {
        return Transaction::where('status', 'pending')->count();
    }

    /**
     * Get pending transfer count (transactions with transfer type)
     */
    public static function getTransferCount(): int
    {
        return Transaction::where('type', 'transfer')
            ->where('status', 'pending')
            ->count();
    }

    /**
     * Get pending deposit count (transactions with deposit type)
     */
    public static function getDepositCount(): int
    {
        return Transaction::where('type', 'deposit')
            ->where('status', 'pending')
            ->count();
    }

    /**
     * Get active virtual card count
     */
    public static function getVirtualCardCount(): int
    {
        return VirtualCard::where('status', 'active')->count();
    }

    /**
     * Get pending KYC count
     */
    public static function getKycCount(): int
    {
        return KycDocument::where('status', 'pending')->count();
    }

    /**
     * Get pending compliance count
     */
    public static function getComplianceCount(): int
    {
        return ComplianceLog::where('status', 'pending')->count();
    }

    /**
     * Get counts without caching (real-time)
     */
    public static function getCachedCounts(): array
    {
        return self::getCounts();
    }
}
