<?php

namespace App\Providers;

use App\Helpers\SettingsHelper;
use App\Providers\CodeServiceProvider;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register CodeServiceProvider
        $this->app->register(CodeServiceProvider::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->configureMailSettings();
    }

    /**
     * Configure mail settings from database
     */
    protected function configureMailSettings(): void
    {
        try {
            $smtpConfig = SettingsHelper::getSmtpConfig();
            
            // Only configure if we have valid SMTP settings (host is required)
            if (!empty($smtpConfig['host'])) {
                // Set default mail driver
                Config::set('mail.default', 'smtp');
                
                // Configure SMTP mailer
                Config::set('mail.mailers.smtp.host', $smtpConfig['host']);
                Config::set('mail.mailers.smtp.port', $smtpConfig['port']);
                Config::set('mail.mailers.smtp.username', $smtpConfig['username']);
                Config::set('mail.mailers.smtp.password', $smtpConfig['password']);
                Config::set('mail.mailers.smtp.encryption', $smtpConfig['encryption']);
                
                // Configure from address and name
                Config::set('mail.from.address', $smtpConfig['from']['address']);
                Config::set('mail.from.name', $smtpConfig['from']['name']);
            }
        } catch (\Exception $e) {
            // Silently fail if settings are not available yet
            // This prevents errors during initial setup or when database is not ready
        }
    }
}
