<?php

namespace App\Livewire\Layout;

use Livewire\Component;

class Navigation extends Component
{
    public $breadcrumbs = [];

    protected $listeners = ['routeChanged'];

    public function mount()
    {
        $this->generateBreadcrumbs();
    }

    public function routeChanged()
    {
        $this->generateBreadcrumbs();
    }

    public function generateBreadcrumbs()
    {
        $route = request()->route();
        $routeName = $route->getName();
        $segments = request()->segments();

        $this->breadcrumbs = [
            ['name' => 'Dashboard', 'url' => route('dashboard'), 'icon' => 'home']
        ];

        // Add dynamic breadcrumbs based on current route
        if ($routeName && $routeName !== 'dashboard') {
            $this->addRouteBreadcrumbs($routeName, $segments);
        }
    }

    protected function addRouteBreadcrumbs($routeName, $segments)
    {
        $routeMap = [
            // Account Management
            'user.account.history' => ['Account', 'History'],
            'user.account.statements' => ['Account', 'Statements'],
            'user.account.settings' => ['Account', 'Settings'],
            
            // Fund Transfer
            'user.transfer.inter-account' => ['Transfer', 'Inter-Account Transfer'],
            'user.transfer.local' => ['Transfer', 'Local Transfer'],
            'user.transfer.international' => ['Transfer', 'International Transfer'],
            'user.transfer.code-verification' => ['Transfer', 'Verification'],
            
            // Deposits
            'user.deposit.cheque' => ['Deposits', 'Cheque Deposit'],
            'user.deposit.history' => ['Deposits', 'Deposit History'],
            
            // User
            'user.beneficiaries' => ['User', 'Beneficiaries'],
            'user.profile' => ['User', 'Profile'],
            'user.kyc-verification' => ['User', 'KYC Verification'],
            
            // Security & Settings
            'user.preferences' => ['Security', 'Preferences'],
        ];

        if (isset($routeMap[$routeName])) {
            foreach ($routeMap[$routeName] as $index => $breadcrumb) {
                $this->breadcrumbs[] = [
                    'name' => $breadcrumb,
                    'url' => null,
                    'icon' => $this->getBreadcrumbIcon($breadcrumb)
                ];
            }
        }
    }

    protected function getBreadcrumbIcon($breadcrumb)
    {
        $iconMap = [
            'Account' => 'credit-card',
            'Settings' => 'cog',
            'History' => 'clock',
            'Statements' => 'document-text',
            'Transfer' => 'paper-airplane',
            'Inter-Account Transfer' => 'arrows-right-left',
            'Local Transfer' => 'paper-airplane',
            'International Transfer' => 'globe-alt',
            'Verification' => 'shield-check',
            'Deposits' => 'arrow-down-tray',
            'Cheque Deposit' => 'document',
            'Deposit History' => 'clock',
            'User' => 'users',
            'Beneficiaries' => 'users',
            'Profile' => 'user',
            'KYC Verification' => 'shield-check',
            'Security' => 'shield-check',
            'Preferences' => 'cog',
        ];

        return $iconMap[$breadcrumb] ?? 'chevron-right';
    }

    public function render()
    {
        return view('livewire.layout.navigation');
    }
}
