<?php

namespace App\Livewire\Layout;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\Account;
use App\Helpers\CurrencyHelper;

class Header extends Component
{
    public $totalBalance = 0;
    public $availableBalance = 0;
    public $user;
    public $primaryAccount = null;
    public $currency = 'USD';

    protected $listeners = ['balanceUpdated'];

    public function mount()
    {
        $this->user = Auth::user();
        $this->loadBalances();
    }

    public function loadBalances()
    {
        // Get user's accounts and calculate balances
        $accounts = $this->user->accounts;
        $primaryAccount = $accounts->where('is_master_account', true)->first();
        
        if ($primaryAccount) {
            $this->totalBalance = $primaryAccount->balance;
            $this->availableBalance = $primaryAccount->available_balance ?? $this->totalBalance;
            $this->currency = $primaryAccount->currency;
            $this->primaryAccount = $primaryAccount;
        } else {
            $this->totalBalance = 0;
            $this->availableBalance = 0;
            $this->currency = 'USD';
            $this->primaryAccount = null;
        }
    }

    public function balanceUpdated()
    {
        $this->loadBalances();
    }

    public function render()
    {
        return view('livewire.layout.header', [
            'currencySymbol' => CurrencyHelper::getSymbol($this->currency)
        ]);
    }
}
