<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RequireProfileCompletion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        // Skip if user is not authenticated
        if (!$user) {
            return $next($request);
        }

        // Skip if user is admin or super-admin
        if ($user->isAdmin() || $user->isSuperAdmin()) {
            return $next($request);
        }

        // Skip if already on profile completion route
        if ($request->routeIs('profile.complete')) {
            return $next($request);
        }

        // Skip if on auth routes (logout, etc.)
        if ($request->routeIs('logout') || $request->routeIs('password.*') || $request->routeIs('verification.*')) {
            return $next($request);
        }

        // Check if user has a profile
        if (!$user->profile) {
            return redirect()->route('profile.complete');
        }

        // Check if profile is complete enough for banking
        if (!$user->profile->isCompleteForBanking()) {
            return redirect()->route('profile.complete');
        }

        return $next($request);
    }
}
