<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CheckBlockedUser
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && Auth::user()->customer_status === 'blocked') {
            Auth::guard('web')->logout();
            Session::invalidate();
            Session::regenerateToken();
            
            // For Livewire/SPA requests
            if ($request->expectsJson() || $request->header('X-Livewire')) {
                return response()->json([
                    'error' => 'Account blocked'
                ], 401)->header('X-Livewire-Redirect', route('login'));
            }
            
            // Redirect to login page
            return redirect()->route('login');
        }

        return $next($request);
    }
}