<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class Allow2FAUsers
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // If user is not authenticated, allow access (guest middleware will handle this)
        if (!Auth::check()) {
            return $next($request);
        }

        $user = Auth::user();
        
        // If user is authenticated but 2FA is required and not completed
        if ($this->isTwoFactorRequired($user)) {
            // Check if we have a pending 2FA session
            if (session()->has('pending_2fa_user_id') && session('pending_2fa_user_id') === $user->id) {
                // User is in pending 2FA state, allow access to login page
                return $next($request);
            }
            
            // User needs 2FA but no pending session, redirect to dashboard
            return redirect()->route('dashboard');
        }
        
        // User is fully authenticated, redirect to dashboard
        return redirect()->route('dashboard');
    }

    /**
     * Check if two-factor authentication is required.
     */
    protected function isTwoFactorRequired($user): bool
    {
        return $user->twoFactorAuth && $user->twoFactorAuth->enabled;
    }
}
