<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rules\Password;

class AdminProfileController extends Controller
{
    /**
     * Display the admin profile
     */
    public function show()
    {
        $admin = Auth::user();
        $admin->load(['roles', 'permissions']);
        
        return view('admin.profile.show', compact('admin'));
    }

    /**
     * Show the form for editing the admin profile
     */
    public function edit()
    {
        $admin = Auth::user();
        
        return view('admin.profile.edit', compact('admin'));
    }

    /**
     * Update the admin profile
     */
    public function update(Request $request)
    {
        $admin = Auth::user();
        
        $validator = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . $admin->id,
            'current_password' => 'required_with:password|current_password',
            'password' => 'nullable|confirmed|min:8',
        ]);

        try {
            // Update basic information
            $admin->update([
                'name' => $request->name,
                'email' => $request->email,
            ]);

            // Handle password update
            if ($request->filled('password')) {
                $admin->update([
                    'password' => Hash::make($request->password)
                ]);
            }

            return redirect()->route('admin.profile.show')
                ->with('success', 'Profile updated successfully.');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Failed to update profile: ' . $e->getMessage())
                ->withInput();
        }
    }

}