<?php

namespace App\Helpers;

class CurrencyHelper
{
    /**
     * Get currency symbol by currency code
     */
    public static function getSymbol(string $currency): string
    {
        return match(strtoupper($currency)) {
            'USD' => '$',
            'EUR' => '€',
            'GBP' => '£',
            default => '$'
        };
    }

    /**
     * Get currency name by currency code
     */
    public static function getName(string $currency): string
    {
        return match(strtoupper($currency)) {
            'USD' => 'US Dollar',
            'EUR' => 'Euro',
            'GBP' => 'British Pound',
            default => 'US Dollar'
        };
    }

    /**
     * Format amount with currency symbol
     */
    public static function format(float $amount, string $currency): string
    {
        $symbol = self::getSymbol($currency);
        return $symbol . number_format($amount, 2);
    }

    /**
     * Get all supported currencies
     */
    public static function getSupportedCurrencies(): array
    {
        return [
            'USD' => ['symbol' => '$', 'name' => 'US Dollar'],
            'EUR' => ['symbol' => '€', 'name' => 'Euro'],
            'GBP' => ['symbol' => '£', 'name' => 'British Pound'],
        ];
    }
}
